<?php
declare(strict_types=1);
require_once __DIR__ . '/../app/bootstrap.php';

function api_get_auth_header(): string {
    // Apache/Nginx variants
    $h = $_SERVER['HTTP_AUTHORIZATION'] ?? $_SERVER['REDIRECT_HTTP_AUTHORIZATION'] ?? '';
    if ($h) return $h;
    if (function_exists('getallheaders')) {
        $all = getallheaders();
        foreach ($all as $k=>$v) {
            if (strcasecmp($k,'Authorization')===0) return (string)$v;
        }
    }
    return '';
}

function api_bearer_token(): string {
    $h = api_get_auth_header();
    if (!$h) return '';
    if (stripos($h, 'Bearer ') === 0) return trim(substr($h, 7));
    return '';
}

/**
 * Return motoboy user array from bearer token, or null.
 * Token is stored in users.api_token and users.api_token_expires_at.
 */
function api_motoboy_from_token(): ?array {
    $token = api_bearer_token();
    if (!$token || strlen($token) < 20) return null;

    $pdo = db();
    $st = $pdo->prepare("SELECT id, username, name, role FROM users WHERE api_token=? AND api_token_expires_at > NOW() AND role='motoboy' AND is_active=1 LIMIT 1");
    $st->execute([$token]);
    $u = $st->fetch();
    return $u ?: null;
}

function api_require_motoboy(): array {
    // allow session too (web panel)
    $u = $_SESSION['user'] ?? null;
    if ($u && ($u['role'] ?? '') === 'motoboy') return $u;

    $u = api_motoboy_from_token();
    if ($u) return $u;

    json_out(['ok'=>false,'error'=>'Não autorizado'], 401);
    exit;
}
