<?php
declare(strict_types=1);
require_once __DIR__ . '/../app/bootstrap.php';

$order_id = (int)($_GET['order_id'] ?? 0);
if ($order_id <= 0) json_out(['ok'=>false,'error'=>'order_id inválido'], 400);

$pdo = db();
$st = $pdo->prepare("SELECT id, status, start_lat, start_lng, dest_lat, dest_lng FROM orders WHERE id=? LIMIT 1");
$st->execute([$order_id]);
$o = $st->fetch();
if (!$o) json_out(['ok'=>false,'error'=>'Pedido inválido'], 404);

$limit = min(600, max(10, (int)($_GET['limit'] ?? 200)));
$st = $pdo->prepare("SELECT lat, lng, created_at FROM order_gps_points WHERE order_id=? ORDER BY id DESC LIMIT {$limit}");
$st->execute([$order_id]);
$pts = array_reverse($st->fetchAll()); // chronological

$last = end($pts) ?: null;

json_out([
    'ok'=>true,
    'order'=>[
        'id'=>(int)$o['id'],
        'status'=>$o['status'],
        'start_lat'=>$o['start_lat'],
        'start_lng'=>$o['start_lng'],
        'dest_lat'=>$o['dest_lat'],
        'dest_lng'=>$o['dest_lng'],
    ],
    'last'=>$last,
    'points'=>$pts,
]);
