<?php
declare(strict_types=1);
require_once __DIR__ . '/_auth.php';

$u = api_require_motoboy();

$order_id = (int)($_POST['order_id'] ?? 0);
$lat = (float)($_POST['lat'] ?? 0);
$lng = (float)($_POST['lng'] ?? 0);

if ($order_id <= 0 || abs($lat) < 0.000001 || abs($lng) < 0.000001) {
    json_out(['ok'=>false,'error'=>'Parâmetros inválidos'], 400);
}

$pdo = db();
$st = $pdo->prepare("SELECT * FROM orders WHERE id=? LIMIT 1");
$st->execute([$order_id]);
$o = $st->fetch();
if (!$o) json_out(['ok'=>false,'error'=>'Pedido inválido'], 404);

$motoId = (int)$u['id'];

if (!empty($o['assigned_motoboy_id']) && (int)$o['assigned_motoboy_id'] !== $motoId) {
    json_out(['ok'=>false,'error'=>'Pedido atribuído a outro motoboy'], 403);
}

// Só registra rota quando started (em entrega)
if (($o['status'] ?? '') !== 'started') {
    json_out(['ok'=>true,'note'=>'status não é started, ping ignorado']);
}

try {
    $pdo->beginTransaction();

    // claim if unassigned
    if (empty($o['assigned_motoboy_id'])) {
        $pdo->prepare("UPDATE orders SET assigned_motoboy_id=? WHERE id=?")->execute([$motoId, $order_id]);
    }

    // set start position if empty
    if (empty($o['start_lat']) || empty($o['start_lng'])) {
        $pdo->prepare("UPDATE orders SET start_lat=?, start_lng=? WHERE id=?")->execute([$lat, $lng, $order_id]);
    }

    // insert point
    $pdo->prepare("INSERT INTO order_gps_points (order_id, motoboy_id, lat, lng, created_at) VALUES (?,?,?,?,?)")
        ->execute([$order_id, $motoId, $lat, $lng, now_dt()]);

    $pdo->commit();

    json_out(['ok'=>true]);
} catch (Throwable $e) {
    if ($pdo->inTransaction()) $pdo->rollBack();
    json_out(['ok'=>false,'error'=>$e->getMessage()], 500);
}
