<?php
declare(strict_types=1);
require_once __DIR__ . '/_auth.php';

$u = api_require_motoboy();
$motoboyId = (int)$u['id'];

$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) json_out(['ok'=>false,'error'=>'Pedido inválido'], 422);

$pdo = db();
$st = $pdo->prepare("SELECT * FROM orders WHERE id=? LIMIT 1");
$st->execute([$id]);
$o = $st->fetch();
if (!$o) json_out(['ok'=>false,'error'=>'Pedido não encontrado'], 404);

$assigned = $o['assigned_motoboy_id'] ? (int)$o['assigned_motoboy_id'] : null;
if ($assigned !== null && $assigned !== $motoboyId) {
    json_out(['ok'=>false,'error'=>'Pedido está com outro motoboy'], 403);
}

json_out(['ok'=>true,'order'=>$o]);
