<?php
declare(strict_types=1);
require_once __DIR__ . '/_auth.php';

$u = api_require_motoboy();
$motoboyId = (int)$u['id'];

if ($_SERVER['REQUEST_METHOD'] !== 'POST') json_out(['ok'=>false,'error'=>'Método inválido'], 405);

$order_id = (int)($_POST['order_id'] ?? 0);
$status = strtolower(trim((string)($_POST['status'] ?? '')));

$allowed = ['started','arrived','delivered'];
if ($order_id <= 0 || !in_array($status, $allowed, true)) {
    json_out(['ok'=>false,'error'=>'Parâmetros inválidos'], 422);
}

$pdo = db();
$pdo->beginTransaction();

$st = $pdo->prepare("SELECT id, status, assigned_motoboy_id FROM orders WHERE id=? FOR UPDATE");
$st->execute([$order_id]);
$o = $st->fetch();
if (!$o) { $pdo->rollBack(); json_out(['ok'=>false,'error'=>'Pedido não encontrado'], 404); }

$assigned = $o['assigned_motoboy_id'] ? (int)$o['assigned_motoboy_id'] : null;
if ($assigned !== null && $assigned !== $motoboyId) {
    $pdo->rollBack();
    json_out(['ok'=>false,'error'=>'Pedido está com outro motoboy'], 403);
}

// Se não estiver atribuído, atribui ao motoboy no primeiro status
if ($assigned === null) {
    $st = $pdo->prepare("UPDATE orders SET assigned_motoboy_id=? WHERE id=?");
    $st->execute([$motoboyId, $order_id]);
}

$now = now_br();

if ($status === 'started') {
    $st = $pdo->prepare("UPDATE orders SET status='started', started_at=COALESCE(started_at, ?) WHERE id=?");
    $st->execute([$now, $order_id]);
} elseif ($status === 'arrived') {
    $st = $pdo->prepare("UPDATE orders SET status='arrived', arrived_at=COALESCE(arrived_at, ?) WHERE id=?");
    $st->execute([$now, $order_id]);
} else { // delivered
    $st = $pdo->prepare("UPDATE orders SET status='delivered', delivered_at=COALESCE(delivered_at, ?) WHERE id=?");
    $st->execute([$now, $order_id]);
}

$pdo->commit();

// (Opcional) enviar WhatsApp via Evolution (já existente no projeto)
if (function_exists('evo_send_status')) {
    evo_send_status($order_id, $status);
}

json_out(['ok'=>true,'order_id'=>$order_id,'status'=>$status,'at'=>$now]);
