<?php
declare(strict_types=1);
require_once __DIR__ . '/../app/bootstrap.php';
require_once __DIR__ . '/../public/_layout.php';
require_moto();

$pdo = db();
$motoId = (int)($_SESSION['user']['id'] ?? 0);

$st = $pdo->prepare("SELECT * FROM orders
                     WHERE (assigned_motoboy_id IS NULL OR assigned_motoboy_id=?) AND status <> 'delivered'
                     ORDER BY id DESC
                     LIMIT 200");
$st->execute([$motoId]);
$orders = $st->fetchAll();

function badge(string $s): string {
    switch ($s) {
        case 'created': return '<span class="badge created">Aguardando</span>';
        case 'started': return '<span class="badge started">Em entrega</span>';
        case 'arrived': return '<span class="badge arrived">Na porta</span>';
        default:        return '<span class="badge">'.h($s).'</span>';
    }
}

page_header('Entregas');
?>
<div class="card">
  <h2>Entregas disponíveis</h2>
  <p style="color:var(--muted);margin-top:-6px">Clique para abrir. Se o pedido não tiver motoboy, ao iniciar ele fica atribuído a você.</p>
  <table class="table">
    <thead>
      <tr><th>#</th><th>Cliente</th><th>Endereço</th><th>Status</th><th></th></tr>
    </thead>
    <tbody>
      <?php foreach($orders as $o): ?>
      <tr>
        <td><?= (int)$o['id'] ?></td>
        <td><?= h($o['customer_name']) ?></td>
        <td><?= h(mb_strimwidth($o['address'],0,60,'…','UTF-8')) ?></td>
        <td><?= badge($o['status']) ?></td>
        <td><a class="btn small info" href="/motoboy/pedido.php?id=<?= (int)$o['id'] ?>">Abrir</a></td>
      </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div>
<?php page_footer(); ?>
