<?php
$token = trim($_GET['t'] ?? '');
$id = (int)($_GET['id'] ?? 0);

if ($token === '' || $id <= 0) {
  echo "Use: teste_gps_api.php?t=SEU_TOKEN&id=1\n";
  exit;
}

$url = "https://farmacia.criarsertao.com.br/api/gps_ping.php";

// Coordenadas de teste (mude se quiser)
$payload = json_encode([
  "order_id" => $id,
  "lat" => -10.600123,
  "lng" => -37.321456,
  "accuracy" => 8,
  "speed" => 10,
  "heading" => 90
]);

$ch = curl_init($url);
curl_setopt_array($ch, [
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_POST => true,
  CURLOPT_POSTFIELDS => $payload,
  CURLOPT_HTTPHEADER => [
    "Authorization: Bearer $token",
    "Content-Type: application/json",
    "Accept: application/json"
  ],
  CURLOPT_TIMEOUT => 20,
]);

$res = curl_exec($ch);
$err = curl_error($ch);
$code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

header("Content-Type: text/plain; charset=utf-8");
echo "HTTP $code\n\n";
if ($err) echo "cURL ERROR: $err\n\n";
echo $res;
