# Farmácia Delivery (PHP) — MVP

Este projeto é um **MVP funcional** em PHP + MySQL, com:
- Cadastro de pedidos com **foto da nota** (upload)
- Salvamento de clientes (por telefone) para reaproveitar dados
- Painel do **atendente** (criar e acompanhar pedidos)
- Painel do **motoboy** (lista de entregas + botões de status)
- Página pública de **acompanhamento** com mapa (Leaflet + OSM)
- Envio de mensagens via **Evolution API** (WhatsApp) a cada status
- Rastreamento do motoboy: envia GPS **a cada 10s** e desenha rota no mapa

> Domínio alvo: https://farmacia.criarsertao.com.br

---

## 1) Requisitos
- PHP 8.1+
- MySQL/MariaDB
- Apache com mod_rewrite habilitado
- Extensões PHP: pdo_mysql, mbstring, gd (para validar imagens), curl

---

## 2) Instalação rápida
1. Suba os arquivos no seu host em: `farmacia.criarsertao.com.br`
2. Copie `.env.example` para `.env` e ajuste:
   - Banco
   - Evolution (base url / token / instância)
3. Crie o banco e rode o script SQL:
   - `database/schema.sql`
4. Acesse:
   - Atendente: `/login.php`
   - Motoboy: `/motoboy/login.php`

### Usuários padrão (troque depois)
- Atendente: `admin` / `admin123`
- Motoboy: `moto` / `moto123`

---

## 3) Rotas principais
- **Atendente**
  - `/admin/pedidos.php` (lista)
  - `/admin/novo_pedido.php` (cadastro)
- **Motoboy**
  - `/motoboy/pedidos.php` (lista)
  - `/motoboy/pedido.php?id=123` (detalhes + botões)
- **Cliente (público)**
  - `/rastreio.php?t=TOKEN_DO_PEDIDO`

---

## 4) Rastreamento (GPS)
- No motoboy, após clicar **Iniciar entrega**, o navegador pede permissão de localização.
- O front envia `lat/lng` a cada 10s para:
  - `POST /api/gps_ping.php`
- O cliente e o atendente veem o mapa (atualiza via polling a cada 5s):
  - `GET /api/gps_latest.php?order_id=...`

---

## 5) Observações importantes
- Este MVP usa *polling* simples (sem WebSocket) para reduzir complexidade.
- Tokens de rastreio são randômicos e longos.
- Para produção, recomenda-se:
  - HTTPS obrigatório
  - `APP_KEY` forte
  - Trocar senhas padrão
  - Limitar tamanho de upload e validar MIME
  - Colocar uploads fora do public (ou proteger via .htaccess)

---

## 6) Próximos passos que podemos evoluir juntos
- Fila de pedidos / atribuição automática ao motoboy
- Notificações “push” (PWA)
- Painel com mapa em tempo real para atendente
- Assinatura digital da entrega (foto/assinatura)
- Cálculo de distância/tempo
