<?php
declare(strict_types=1);
require_once __DIR__ . '/../app/bootstrap.php';
require_once __DIR__ . '/../public/_layout.php';
require_login('admin');

$pdo = db();
$id = (int)($_GET['id'] ?? 0);

$st = $pdo->prepare("SELECT * FROM orders WHERE id=? LIMIT 1");
$st->execute([$id]);
$o = $st->fetch();
if (!$o) { http_response_code(404); exit('Pedido não encontrado'); }

$ok = $err = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    csrf_check();
    try{
        $dest_lat = trim((string)($_POST['dest_lat'] ?? ''));
        $dest_lng = trim((string)($_POST['dest_lng'] ?? ''));
        if ($dest_lat === '' || $dest_lng === '') throw new Exception('Informe lat/lng.');
        $pdo->prepare("UPDATE orders SET dest_lat=?, dest_lng=? WHERE id=?")->execute([(float)$dest_lat,(float)$dest_lng,$id]);
        $ok = 'Destino atualizado.';
    }catch(Throwable $e){ $err = $e->getMessage(); }
}

page_header('Definir destino');
?>
<div class="card">
  <h2>Definir destino (lat/lng) — Pedido #<?= (int)$o['id'] ?></h2>
  <p style="color:var(--muted);margin-top:-6px">Neste MVP, o destino é manual. Se quiser, depois integramos geocoding automático pelo endereço.</p>

  <?php if($ok): ?><div class="notice ok"><?= h($ok) ?></div><?php endif; ?>
  <?php if($err): ?><div class="notice err"><?= h($err) ?></div><?php endif; ?>

  <form method="post">
    <input type="hidden" name="_csrf" value="<?= h(csrf_token()) ?>">
    <div class="row">
      <div>
        <label>dest_lat</label>
        <input name="dest_lat" value="<?= h((string)($o['dest_lat'] ?? '')) ?>" placeholder="-10.123456">
      </div>
      <div>
        <label>dest_lng</label>
        <input name="dest_lng" value="<?= h((string)($o['dest_lng'] ?? '')) ?>" placeholder="-37.123456">
      </div>
    </div>
    <div style="margin-top:12px;display:flex;gap:10px;flex-wrap:wrap">
      <button class="btn primary" type="submit">Salvar</button>
      <a class="btn" href="/admin/pedido.php?id=<?= (int)$o['id'] ?>">Voltar</a>
    </div>
  </form>
</div>
<?php page_footer(); ?>
