<?php
declare(strict_types=1);
require_once __DIR__ . '/../app/bootstrap.php';
require_once __DIR__ . '/../public/_layout.php';
require_login('admin');

$pdo = db();

$st = $pdo->query("SELECT o.*, u.name AS motoboy_name
                   FROM orders o
                   LEFT JOIN users u ON u.id=o.assigned_motoboy_id
                   ORDER BY o.id DESC
                   LIMIT 200");
$orders = $st->fetchAll();

function badge(string $s): string {
    switch ($s) {
        case 'created':   return '<span class="badge created">Cadastrado</span>';
        case 'started':   return '<span class="badge started">Em entrega</span>';
        case 'arrived':   return '<span class="badge arrived">Chegou</span>';
        case 'delivered': return '<span class="badge delivered">Finalizado</span>';
        default:          return '<span class="badge">'.h($s).'</span>';
    }
}

page_header('Pedidos');
?>
<div class="card">
  <h2>Pedidos</h2>
  <table class="table">
    <thead>
      <tr>
        <th>#</th><th>Cliente</th><th>Telefone</th><th>Status</th><th>Motoboy</th><th>Criado</th><th></th>
      </tr>
    </thead>
    <tbody>
      <?php foreach($orders as $o): ?>
      <tr>
        <td><?= (int)$o['id'] ?></td>
        <td><?= h($o['customer_name']) ?></td>
        <td><?= h($o['customer_phone']) ?></td>
        <td><?= badge($o['status']) ?></td>
        <td><?= h($o['motoboy_name'] ?? '-') ?></td>
        <td><?= h($o['created_at']) ?></td>
        <td><a class="btn small info" href="/admin/pedido.php?id=<?= (int)$o['id'] ?>">Abrir</a></td>
      </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div>
<?php page_footer(); ?>
