<?php
declare(strict_types=1);
require_once __DIR__ . '/../app/bootstrap.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    json_out(['ok'=>false,'error'=>'Método inválido'], 405);
}

$username = trim((string)($_POST['username'] ?? ''));
$password = (string)($_POST['password'] ?? '');

if ($username === '' || $password === '') {
    json_out(['ok'=>false,'error'=>'Informe usuário e senha'], 422);
}

$pdo = db();
$st = $pdo->prepare("SELECT id, username, name, role, password_hash, is_active FROM users WHERE username=? AND role='motoboy' LIMIT 1");
$st->execute([$username]);
$u = $st->fetch();

if (!$u || (int)$u['is_active'] !== 1 || !password_verify($password, (string)$u['password_hash'])) {
    json_out(['ok'=>false,'error'=>'Login inválido'], 401);
}

$token = bin2hex(random_bytes(32));
$expires = (new DateTime('now', new DateTimeZone('America/Sao_Paulo')))->modify('+7 days')->format('Y-m-d H:i:s');

$st = $pdo->prepare("UPDATE users SET api_token=?, api_token_expires_at=? WHERE id=?");
$st->execute([$token, $expires, (int)$u['id']]);

json_out([
    'ok'=>true,
    'token'=>$token,
    'expires_at'=>$expires,
    'motoboy'=>[
        'id'=>(int)$u['id'],
        'username'=>$u['username'],
        'name'=>$u['name'],
    ]
]);
