<?php
declare(strict_types=1);
require_once __DIR__ . '/bootstrap.php';

function login_attempt(string $username, string $password, string $role): bool {
    $pdo = db();
    $st = $pdo->prepare("SELECT id, username, password_hash, role, name FROM users WHERE username=? AND role=? AND is_active=1 LIMIT 1");
    $st->execute([$username, $role]);
    $u = $st->fetch();
    if (!$u) return false;
    if (!password_verify($password, $u['password_hash'])) return false;
    $_SESSION['user'] = [
        'id' => (int)$u['id'],
        'username' => $u['username'],
        'role' => $u['role'],
        'name' => $u['name'],
    ];
    return true;
}

function logout(): void {
    $_SESSION = [];
    if (ini_get("session.use_cookies")) {
        $params = session_get_cookie_params();
        setcookie(session_name(), '', time() - 42000,
            $params["path"], $params["domain"],
            $params["secure"], $params["httponly"]
        );
    }
    session_destroy();
}
