<?php
declare(strict_types=1);
require_once __DIR__ . '/bootstrap.php';

/**
 * Envia mensagem via Evolution API.
 * Ajuste o endpoint conforme seu Evolution.
 * Este MVP tenta um formato comum: /message/sendText/{instance}
 */
function evo_send_text(string $toPhoneE164, string $message): array {
    $base = rtrim((string)env('EVO_BASE_URL',''), '/');
    $instance = (string)env('EVO_INSTANCE','');
    $token = (string)env('EVO_TOKEN','');

    if ($base === '' || $instance === '' || $token === '') {
        return ['ok'=>false, 'error'=>'Evolution não configurado (.env)'];
    }

    $url = $base . "/message/sendText/" . rawurlencode($instance);

    $payload = [
        "number" => $toPhoneE164,
        "text" => $message
    ];

    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_POST => true,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => [
            "Content-Type: application/json",
            "apikey: {$token}"
        ],
        CURLOPT_POSTFIELDS => json_encode($payload, JSON_UNESCAPED_UNICODE),
        CURLOPT_TIMEOUT => 15,
    ]);
    $resp = curl_exec($ch);
    $err = curl_error($ch);
    $http = (int)curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($resp === false) {
        return ['ok'=>false, 'error'=>$err ?: 'Falha cURL'];
    }

    $data = json_decode($resp, true);
    $ok = ($http >= 200 && $http < 300);

    return ['ok'=>$ok, 'http'=>$http, 'response'=>$data ?? $resp];
}

function msg_template(string $status, array $order): string {
    $nome = $order['customer_name'] ?? 'Cliente';
    $id = $order['id'] ?? '';
    $url = (string)env('APP_URL','') . "/rastreio.php?t=" . ($order['track_token'] ?? '');
    switch ($status) {
    case 'created':
        return "Olá, {$nome}! Seu pedido foi cadastrado ✅
Acompanhe aqui: {$url}
Pedido #{$id}";
    case 'started':
        return "Seu pedido saiu para entrega 🏍️✅
Acompanhe: {$url}
Pedido #{$id}";
    case 'arrived':
        return "O motoboy está em frente à sua residência 📍
Acompanhe: {$url}
Pedido #{$id}";
    case 'delivered':
        return "Entrega finalizada ✅
Obrigado por comprar conosco! 🙏
Pedido #{$id}";
    default:
        return "Atualização do pedido #{$id}: {$status}
{$url}";
}
}


/**
 * Envia WhatsApp via Evolution baseado no status (created/started/arrived/delivered).
 * Usa os dados do pedido e telefone do cliente.
 */
function evo_send_status(int $order_id, string $status): void {
    $pdo = db();
    $st = $pdo->prepare("SELECT id, customer_name, customer_phone, track_token, status AS st FROM orders WHERE id=? LIMIT 1");
    $st->execute([$order_id]);
    $o = $st->fetch();
    if (!$o) return;

    $nome = (string)$o['customer_name'];
    $id = (int)$o['id'];
    $url = rtrim(env('APP_URL',''), '/') . '/rastreio.php?t=' . $o['track_token'];

    $msg = msg_template($status, $nome, $url, $id);
    $phone = preg_replace('/\D+/', '', (string)$o['customer_phone']);

    if ($phone === '') return;

    // envia texto
    evo_send_text($phone, $msg);
}
