<?php
declare(strict_types=1);
require_once __DIR__ . '/../app/bootstrap.php';

function page_header(string $title): void {
    $user = $_SESSION['user'] ?? null;
    ?>
<!doctype html>
<html lang="pt-br">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= h($title) ?></title>
  <link rel="stylesheet" href="/public/assets/app.css?v=1">
</head>
<body>
  <header class="topbar">
    <div class="container">
      <div class="brand">Farmácia Delivery</div>
      <div class="right">
        <?php if ($user): ?>
          <span class="user">Olá, <?= h($user['name'] ?? $user['username']) ?></span>
          <?php if (($user['role'] ?? '') === 'admin'): ?>
            <a class="btn small" href="/admin/pedidos.php">Pedidos</a>
            <a class="btn small" href="/admin/novo_pedido.php">Novo</a>
            <a class="btn small" href="/logout.php">Sair</a>
          <?php else: ?>
            <a class="btn small" href="/motoboy/pedidos.php">Entregas</a>
            <a class="btn small" href="/motoboy/logout.php">Sair</a>
          <?php endif; ?>
        <?php endif; ?>
      </div>
    </div>
  </header>
  <main class="container">
<?php
}

function page_footer(): void { ?>
  </main>
  <footer class="footer">
    <div class="container">
      <small>© <?= date('Y') ?> Farmácia Delivery</small>
    </div>
  </footer>
</body>
</html>
<?php }
