<?php
declare(strict_types=1);
require_once __DIR__ . '/app/bootstrap.php';
require_once __DIR__ . '/public/_layout.php';

$token = trim((string)($_GET['t'] ?? ''));
if ($token === '' || strlen($token) < 20) {
    http_response_code(400);
    exit('Link inválido.');
}

$pdo = db();
$st = $pdo->prepare("SELECT * FROM orders WHERE track_token=? LIMIT 1");
$st->execute([$token]);
$o = $st->fetch();
if (!$o) { http_response_code(404); exit('Pedido não encontrado.'); }

page_header('Rastreio do Pedido');
?>
<div class="card">
  <h2>Acompanhar pedido #<?= (int)$o['id'] ?></h2>
  <div class="kv">
    <div><b>Cliente</b></div><div><?= h($o['customer_name']) ?></div>
    <div><b>Status</b></div><div id="statusTxt"><?= h(status_label($o['status'])) ?></div>
    <div><b>Criado</b></div><div><?= h($o['created_at']) ?></div>
    <div><b>Endereço</b></div><div><?= nl2br(h($o['address'])) ?></div>
  </div>

  <?php if($o['note_image_path']): ?>
    <hr>
    <h3>Nota</h3>
    <a class="btn info" target="_blank" href="/<?= h($o['note_image_path']) ?>">Abrir imagem</a>
    <div style="margin-top:10px">
      <img src="/<?= h($o['note_image_path']) ?>" style="max-width:100%;border-radius:12px;border:1px solid rgba(255,255,255,.10)">
    </div>
  <?php endif; ?>
</div>

<div class="card">
  <h3>Mapa</h3>
  <div id="map" style="height:520px;border-radius:14px;border:1px solid rgba(255,255,255,.10)"></div>
  <div class="notice" style="margin-top:10px;color:var(--muted)">
    Setas: <b style="color:var(--accent)">Verde</b> (início) • <b style="color:#ff6b6b">Vermelha</b> (motoboy) • <b style="color:#4dabf7">Azul</b> (destino)
  </div>
</div>

<link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" integrity="sha256-p4NxAoJBhIIN+hmNHrzRCf9tD/miZyoHS5obTRR9BMY=" crossorigin=""/>
<script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js" integrity="sha256-20nQCchB9co0qIjJZRGuk2/Z9VM+kNiyxNV1lvTlZBo=" crossorigin=""></script>

<script>
const orderId = <?= (int)$o['id'] ?>;
const token = <?= json_encode($token) ?>;

const map = L.map('map');
const osm = L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {maxZoom: 19});
osm.addTo(map);

const greenIcon = new L.Icon({
  iconUrl: 'https://raw.githubusercontent.com/pointhi/leaflet-color-markers/master/img/marker-icon-2x-green.png',
  shadowUrl: 'https://unpkg.com/leaflet@1.9.4/dist/images/marker-shadow.png',
  iconSize: [25, 41], iconAnchor: [12, 41], popupAnchor: [1, -34], shadowSize: [41, 41]
});
const redIcon = new L.Icon({
  iconUrl: 'https://raw.githubusercontent.com/pointhi/leaflet-color-markers/master/img/marker-icon-2x-red.png',
  shadowUrl: 'https://unpkg.com/leaflet@1.9.4/dist/images/marker-shadow.png',
  iconSize: [25, 41], iconAnchor: [12, 41], popupAnchor: [1, -34], shadowSize: [41, 41]
});
const blueIcon = new L.Icon({
  iconUrl: 'https://raw.githubusercontent.com/pointhi/leaflet-color-markers/master/img/marker-icon-2x-blue.png',
  shadowUrl: 'https://unpkg.com/leaflet@1.9.4/dist/images/marker-shadow.png',
  iconSize: [25, 41], iconAnchor: [12, 41], popupAnchor: [1, -34], shadowSize: [41, 41]
});

let startMarker = null;
let motoMarker = null;
let destMarker = null;
let routeLine = L.polyline([], {weight: 4}).addTo(map);

function fitAll(points){
  const group = L.featureGroup(points.filter(Boolean));
  if(group.getLayers().length){
    map.fitBounds(group.getBounds().pad(0.25));
  }
}

async function fetchOrder(){
  const r = await fetch('/api/order_by_token.php?t=' + encodeURIComponent(token));
  const j = await r.json();
  if(!j.ok) throw new Error(j.error || 'Falha');
  const mapStatus={created:'Pedido cadastrado',started:'Entrega iniciada',arrived:'Motoboy em frente à residência',delivered:'Entrega finalizada'};
document.getElementById('statusTxt').textContent = (mapStatus[j.order.status]||j.order.status);
  return j.order;
}

async function fetchGps(){
  const r = await fetch('/api/gps_latest.php?order_id=' + orderId + '&limit=300');
  const j = await r.json();
  if(!j.ok) throw new Error(j.error || 'Falha GPS');
  return j;
}

async function refresh(){
  try{
    const order = await fetchOrder();
    const gps = await fetchGps();

    // destino: neste MVP, o destino pode ficar vazio (podemos geocodificar depois).
    // Por enquanto: quando não tiver dest, não mostra.
    const startLat = parseFloat(gps.order.start_lat || '');
    const startLng = parseFloat(gps.order.start_lng || '');
    const destLat = parseFloat(gps.order.dest_lat || '');
    const destLng = parseFloat(gps.order.dest_lng || '');

    if(!isNaN(startLat) && !isNaN(startLng)){
      if(!startMarker) startMarker = L.marker([startLat, startLng], {icon: greenIcon}).addTo(map).bindPopup('Início (motoboy)');
      else startMarker.setLatLng([startLat, startLng]);
    }

    if(!isNaN(destLat) && !isNaN(destLng)){
      if(!destMarker) destMarker = L.marker([destLat, destLng], {icon: blueIcon}).addTo(map).bindPopup('Destino');
      else destMarker.setLatLng([destLat, destLng]);
    }

    const last = gps.last;
    if(last){
      const lat = parseFloat(last.lat), lng = parseFloat(last.lng);
      if(!motoMarker) motoMarker = L.marker([lat, lng], {icon: redIcon}).addTo(map).bindPopup('Motoboy');
      else motoMarker.setLatLng([lat, lng]);
    }

    const pts = gps.points || [];
    const latlngs = pts.map(p => [parseFloat(p.lat), parseFloat(p.lng)]).filter(a => !isNaN(a[0]) && !isNaN(a[1]));
    routeLine.setLatLngs(latlngs);

    if(!window.__fitted){
      fitAll([startMarker, motoMarker, destMarker, routeLine]);
      if(!map.getCenter().lat){ map.setView([-10.6, -37.3], 13); } // fallback Sertão
      window.__fitted = true;
    }
  }catch(e){
    console.warn(e);
  }
}

refresh();
setInterval(refresh, 5000);
</script>

<?php page_footer(); ?>
