<?php
declare(strict_types=1);
require_once __DIR__ . '/../app/bootstrap.php';
require_once __DIR__ . '/../public/_layout.php';
require_login('admin');

$pdo = db();
$id = (int)($_GET['id'] ?? 0);
$st = $pdo->prepare("SELECT o.*, u.name AS motoboy_name FROM orders o LEFT JOIN users u ON u.id=o.assigned_motoboy_id WHERE o.id=? LIMIT 1");
$st->execute([$id]);
$o = $st->fetch();
if (!$o) { http_response_code(404); exit('Pedido não encontrado'); }

$events = $pdo->prepare("SELECT * FROM order_events WHERE order_id=? ORDER BY id DESC LIMIT 50");
$events->execute([$id]);
$events = $events->fetchAll();

$trackUrl = env('APP_URL','') . "/rastreio.php?t=" . $o['track_token'];

page_header('Pedido #'.$id);
?>
<div class="card">
  <h2>Pedido #<?= (int)$o['id'] ?></h2>
  <div class="kv">
    <div><b>Cliente</b></div><div><?= h($o['customer_name']) ?></div>
    <div><b>Telefone</b></div><div><?= h($o['customer_phone']) ?></div>
    <div><b>Endereço</b></div><div><?= nl2br(h($o['address'])) ?></div>
    <div><b>Status</b></div><div><?= h(status_label($o['status'])) ?></div>
    <div><b>Motoboy</b></div><div><?= h($o['motoboy_name'] ?? '-') ?></div>
    <div><b>Rastreio</b></div><div><a class="btn small info" target="_blank" href="<?= h($trackUrl) ?>">Abrir link</a></div>
    <div><b>Destino</b></div><div><a class="btn small" href="/admin/definir_destino.php?id=<?= (int)$o['id'] ?>">Definir lat/lng</a></div>

  </div>

  <?php if($o['note_image_path']): ?>
    <hr>
    <h3>Nota</h3>
    <a class="btn info" target="_blank" href="/<?= h($o['note_image_path']) ?>">Abrir imagem</a>
    <div style="margin-top:10px">
      <img src="/<?= h($o['note_image_path']) ?>" style="max-width:100%;border-radius:12px;border:1px solid rgba(255,255,255,.10)">
    </div>
  <?php endif; ?>
</div>

<div class="card">
  <h3>Eventos</h3>
  <table class="table">
    <thead><tr><th>Quando</th><th>Evento</th><th>Obs.</th></tr></thead>
    <tbody>
      <?php foreach($events as $e): ?>
      <tr>
        <td><?= h($e['created_at']) ?></td>
        <td><?= h($e['event']) ?></td>
        <td><?= h($e['note'] ?? '') ?></td>
      </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div>

<div class="card">
  <h3>Mapa (rastreio)</h3>
  <p style="color:var(--muted);margin-top:-4px">O mapa abaixo é o mesmo do cliente, usando o token do pedido.</p>
  <a class="btn info" href="<?= h($trackUrl) ?>" target="_blank">Abrir em nova aba</a>
  <iframe src="/mapa.php?t=<?= h($o['track_token']) ?>" style="width:100%;height:520px;border:1px solid rgba(255,255,255,.10);border-radius:14px;margin-top:10px"></iframe>
</div>

<?php page_footer(); ?>
