<?php
declare(strict_types=1);
require_once __DIR__ . '/_auth.php';

$u = api_require_motoboy();
$motoboyId = (int)$u['id'];

$tz = new DateTimeZone('America/Sao_Paulo');
$day = trim((string)($_GET['date'] ?? ''));
if ($day === '') $day = (new DateTime('now', $tz))->format('Y-m-d');

$start = $day . ' 00:00:00';
$end   = $day . ' 23:59:59';

$pdo = db();

// pedidos do dia: atribuídos ao motoboy OU ainda sem motoboy (para ele pegar)
$st = $pdo->prepare("
    SELECT id, customer_name, customer_phone, address, status, created_at, started_at, arrived_at, delivered_at,
           assigned_motoboy_id, track_token
    FROM orders
    WHERE created_at BETWEEN ? AND ?
      AND (assigned_motoboy_id IS NULL OR assigned_motoboy_id = ?)
    ORDER BY FIELD(status,'created','started','arrived','delivered'), id DESC
");
$st->execute([$start, $end, $motoboyId]);
$rows = $st->fetchAll();

json_out(['ok'=>true,'date'=>$day,'orders'=>$rows]);
