<?php
declare(strict_types=1);
require_once __DIR__ . '/../app/auth.php';
require_once __DIR__ . '/../public/_layout.php';

$err = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    csrf_check();
    $u = trim((string)($_POST['username'] ?? ''));
    $p = (string)($_POST['password'] ?? '');
    if (login_attempt($u, $p, 'motoboy')) {
        redirect('/motoboy/pedidos.php');
    } else {
        $err = 'Login inválido.';
    }
}

page_header('Login - Motoboy');
?>
<div class="card">
  <h2>Login (Motoboy)</h2>
  <?php if($err): ?><div class="notice err"><?= h($err) ?></div><?php endif; ?>
  <form method="post">
    <input type="hidden" name="_csrf" value="<?= h(csrf_token()) ?>">
    <label>Usuário</label>
    <input name="username" autocomplete="username" required>
    <label>Senha</label>
    <input type="password" name="password" autocomplete="current-password" required>
    <div style="margin-top:12px;display:flex;gap:10px;align-items:center;flex-wrap:wrap">
      <button class="btn primary" type="submit">Entrar</button>
      <a class="btn" href="/login.php">Sou atendente</a>
    </div>
  </form>
</div>
<?php page_footer(); ?>
