<?php
declare(strict_types=1);
require_once __DIR__ . '/../app/bootstrap.php';
require_once __DIR__ . '/../app/evolution.php';
require_once __DIR__ . '/../public/_layout.php';
require_moto();

$pdo = db();
$motoId = (int)($_SESSION['user']['id'] ?? 0);
$id = (int)($_GET['id'] ?? 0);

$st = $pdo->prepare("SELECT * FROM orders WHERE id=? LIMIT 1");
$st->execute([$id]);
$o = $st->fetch();
if (!$o) { http_response_code(404); exit('Pedido não encontrado'); }

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    csrf_check();
    $action = (string)($_POST['action'] ?? '');
    try {
        $pdo->beginTransaction();

        // refresh
        $st = $pdo->prepare("SELECT * FROM orders WHERE id=? FOR UPDATE");
        $st->execute([$id]);
        $o = $st->fetch();
        if (!$o) throw new Exception('Pedido não encontrado.');

        // claim if unassigned
        if (empty($o['assigned_motoboy_id'])) {
            $pdo->prepare("UPDATE orders SET assigned_motoboy_id=? WHERE id=?")->execute([$motoId, $id]);
            $o['assigned_motoboy_id'] = $motoId;
        } elseif ((int)$o['assigned_motoboy_id'] !== $motoId) {
            throw new Exception('Este pedido já está atribuído a outro motoboy.');
        }

        if ($action === 'start' && $o['status'] === 'created') {
            $pdo->prepare("UPDATE orders SET status='started', started_at=? WHERE id=?")->execute([now_dt(), $id]);
            $pdo->prepare("INSERT INTO order_events (order_id, event, note, created_at) VALUES (?,?,?,?)")
                ->execute([$id, 'started', 'Entrega iniciada', now_dt()]);
            $o['status'] = 'started';

            evo_send_text($o['customer_phone'], msg_template('started', $o));
        }

        if ($action === 'arrived' && $o['status'] === 'started') {
            $pdo->prepare("UPDATE orders SET status='arrived', arrived_at=? WHERE id=?")->execute([now_dt(), $id]);
            $pdo->prepare("INSERT INTO order_events (order_id, event, note, created_at) VALUES (?,?,?,?)")
                ->execute([$id, 'arrived', 'Motoboy em frente', now_dt()]);
            $o['status'] = 'arrived';

            evo_send_text($o['customer_phone'], msg_template('arrived', $o));
        }

        if ($action === 'deliver' && in_array($o['status'], ['started','arrived'], true)) {
            $pdo->prepare("UPDATE orders SET status='delivered', delivered_at=? WHERE id=?")->execute([now_dt(), $id]);
            $pdo->prepare("INSERT INTO order_events (order_id, event, note, created_at) VALUES (?,?,?,?)")
                ->execute([$id, 'delivered', 'Entrega finalizada', now_dt()]);
            $o['status'] = 'delivered';

            evo_send_text($o['customer_phone'], msg_template('delivered', $o));
        }

        $pdo->commit();
        redirect('/motoboy/pedido.php?id=' . $id);
    } catch (Throwable $e) {
        if ($pdo->inTransaction()) $pdo->rollBack();
        $err = $e->getMessage();
    }
}

$trackUrl = env('APP_URL','') . "/rastreio.php?t=" . $o['track_token'];

page_header('Pedido #'.$id);
?>
<div class="card">
  <h2>Pedido #<?= (int)$o['id'] ?></h2>

  <?php if(!empty($err ?? '')): ?><div class="notice err"><?= h($err) ?></div><?php endif; ?>

  <div class="kv">
    <div><b>Cliente</b></div><div><?= h($o['customer_name']) ?></div>
    <div><b>Telefone</b></div><div><?= h($o['customer_phone']) ?></div>
    <div><b>Endereço</b></div><div><?= nl2br(h($o['address'])) ?></div>
    <div><b>Status</b></div><div><?= h(status_label($o['status'])) ?></div>
    <div><b>Rastreio</b></div><div><a class="btn small info" target="_blank" href="<?= h($trackUrl) ?>">Abrir</a></div>
  </div>

  <hr>
  <form method="post" id="statusForm" style="display:flex;gap:10px;flex-wrap:wrap">
    <input type="hidden" name="_csrf" value="<?= h(csrf_token()) ?>">
    <?php if($o['status'] === 'created'): ?>
      <button class="btn primary" name="action" value="start">Iniciar Entrega</button>
    <?php endif; ?>
    <?php if($o['status'] === 'started'): ?>
      <button class="btn info" name="action" value="arrived">Estou em Frente da Residência</button>
      <button class="btn primary" name="action" value="deliver">Entrega finalizada</button>
    <?php endif; ?>
    <?php if($o['status'] === 'arrived'): ?>
      <button class="btn primary" name="action" value="deliver">Entrega finalizada</button>
    <?php endif; ?>
    <a class="btn" href="/motoboy/pedidos.php">Voltar</a>
  </form>

  <div class="notice" id="gpsNotice" style="margin-top:14px;display:none"></div>
</div>

<div class="card">
  <h3>GPS (envio a cada 10 segundos)</h3>
  <p style="color:var(--muted);margin-top:-6px">
    Quando o status estiver em <b>started</b>, esta página começará a enviar sua localização automaticamente.
  </p>
  <button class="btn" id="btnTestGps" type="button">Testar GPS agora</button>
</div>

<script>
const orderId = <?= (int)$o['id'] ?>;
const canTrack = <?= ($o['status']==='started' ? 'true':'false') ?>;

function showNotice(msg, ok=true){
  const el = document.getElementById('gpsNotice');
  el.style.display='block';
  el.className = 'notice ' + (ok ? 'ok':'err');
  el.textContent = msg;
}

async function sendPing(lat,lng){
  const form = new FormData();
  form.append('order_id', orderId);
  form.append('lat', lat);
  form.append('lng', lng);
  const res = await fetch('/api/gps_ping.php', {method:'POST', body: form});
  const j = await res.json();
  if(!j.ok) throw new Error(j.error || 'Falha');
  return j;
}

function getLocationOnce(){
  return new Promise((resolve,reject)=>{
    if(!navigator.geolocation) return reject(new Error('Geolocalização não suportada.'));
    navigator.geolocation.getCurrentPosition(
      p => resolve({lat:p.coords.latitude, lng:p.coords.longitude}),
      e => reject(new Error('Permissão/erro de GPS: ' + e.message)),
      {enableHighAccuracy:true, timeout:15000, maximumAge:0}
    );
  });
}

async function pingNow(){
  try{
    const pos = await getLocationOnce();
    await sendPing(pos.lat, pos.lng);
    showNotice('GPS enviado: ' + pos.lat.toFixed(6) + ', ' + pos.lng.toFixed(6), true);
  }catch(err){
    showNotice(err.message, false);
  }
}

document.getElementById('btnTestGps').addEventListener('click', pingNow);

if(canTrack){
  // envia primeiro ping e depois a cada 10s
  pingNow();
  setInterval(pingNow, 10000);
}
</script>

<?php page_footer(); ?>
